<?php

if (function_exists("set_time_limit")==1 and get_cfg_var("safe_mode")==0) {
  set_time_limit(1200);
}

require ("./global.php");

function wordsonly ($text) {

  $text=strtolower($text);

  echo "-";
  flush();
  $text=ereg_replace("<pre>[^<]*</pre>"," ",$text);
  echo "-";
  flush();
  $text=ereg_replace("<[^>]*>"," ",$text); // remove HTML <> tags
  echo "-";
  flush();
  $text=ereg_replace("&[^;];"," ",$text); // remove HTML special chars
  echo "-";
  flush();
  $text=ereg_replace("[^ 0-9a-z]"," ",$text); // keep only letters and numbers
  echo "-";
  flush();

  $counter=0;

  $words=explode(" ",$text);
  while (list($key,$val)=each($words)) {
    if (strlen($val)>2 and $val!="the" and $val!="this" and $val!="and" and $val!="but" and $val!="was" and $val!="that" and $val!="with" and $val!="its" and $val!="you" and $val!="they" and $val!="what" and $val!="why" and $val!="for" and $val!="are" and $val!="our" and $val!="then" and $val!="there" and $val!="which") {
      $counter++;
      $wordarray[$val]=1;
    }
  }

  if ($counter>0) {
    while (list($key,$val)=each($wordarray)) {
      $newwords[]=$key;
    }

    $newwords=implode($newwords," ");
  } else {
    $newwords="";
  }

  return $newwords;
}


?>
<html>
<body>

<?php
// ###################### Start user choices #######################
if (isset($action)==0 or $action=="") {

  echo "<p><b>Update Forums Info</b> - update forum post counts<br>\n";

  echo doformheader("misc","updateforum");
  echo "<table border=0>";
  echo makeinputcode("Number of forums to do per cycle","perpage","100");
  echo doformfooter();

  echo "<p><b>Update Thread Info</b> - update thread post counts, original posters and last post date<br>\n";

  echo doformheader("misc","updatethread");
  echo "<table border=0>";
  echo makeinputcode("Number of threads to do per cycle","perpage","2000");
  echo doformfooter();

  echo "<p><b>Rebuild search Index</b><br>\n";

  echo doformheader("misc","buildsearchindex");
  echo "<table border=0>";
  echo makeinputcode("Number of threads to do per cycle","perpage","500");
  echo doformfooter();

}

// ###################### Start build search index #######################
if ($action=="buildsearchindex") {
  if (isset($perpage)==0 or $perpage=="") {
    $perpage=500;
  }
  if (isset($startat)==0 or $startat=="") {
    $startat=0;
  }
  $finishat=$startat+$perpage;

  echo "<p>Building index..</p>";
  $threads=$DB_site->query("SELECT DISTINCT thread.threadid,thread.title FROM post,thread WHERE thread.threadid=post.threadid AND thread.threadid>=$startat AND thread.threadid<$finishat ORDER BY thread.threadid");
  while ($thread=$DB_site->fetch_array($threads)) {

    $subject="";
    $pagetext="";
    $usernames="";

    echo "<p>Gathering data for thread$thread[threadid]<br>";
    flush();

    $subject=$thread[title];

    $posts=$DB_site->query("SELECT username,pagetext FROM post WHERE threadid=$thread[threadid]");
    while ($post=$DB_site->fetch_array($posts)) {
      $usernames.=" $post[username] ";
      $pagetext.=" $post[pagetext] ";
    }


    $subject=wordsonly($subject);
    $pagetext=$subject." ".wordsonly($pagetext);
    $usernames=wordsonly($usernames);

    $DB_site->query("UPDATE thread SET subjectindex=' ".addslashes($subject)." ',threadindex=' ".addslashes($pagetext)." ',userindex=' ".addslashes($usernames)." ' WHERE threadid=$thread[threadid]");
    echo "</p>\n";
    flush();

  }

  if ($checkmore=$DB_site->query_first("SELECT threadid FROM thread WHERE threadid>=$finishat")) {
    echo "<script language=\"javascript\">window.location=\"misc.php?action=buildsearchindex&startat=$finishat&perpage=$perpage\";</script>";
    echo "<p><a href=\"misc.php?action=buildsearchindex&startat=$finishat&perpage=$perpage\">Click here to continue building search engine</a></p>";
  } else {
    echo "<p>All done!</p>";
  }
}


// ###################### Start update forum #######################
if ($action=="updateforum") {
  if (isset($perpage)==0 or $perpage=="") {
    $perpage=100;
  }
  if (isset($startat)==0 or $startat=="") {
    $startat=0;
  }
  $finishat=$startat+$perpage;

  echo "<p>Forum ids:</p>";

  $forums=$DB_site->query("SELECT forumid FROM forum WHERE forumid>=$startat AND forumid<$finishat ORDER BY forumid DESC");
  while ($forum=$DB_site->fetch_array($forums)) {

    $forumid=$forum[forumid];

    echo "$forumid<br>\n";
    flush();

    if ($numpost=$DB_site->query_first("SELECT COUNT(postid) AS posts FROM post,thread WHERE thread.threadid=post.threadid AND thread.forumid=$forumid")) {
      $numberposts=$numpost[posts];
    } else {
      $numberposts=0;
    }

    if ($numpost=$DB_site->query_first("SELECT COUNT(threadid) AS posts FROM thread WHERE thread.forumid=$forumid")) {
      $numberthreads=$numpost[posts];
    } else {
      $numberthreads=0;
    }

    if ($lastposts=$DB_site->query_first("SELECT lastpost FROM thread WHERE forumid=$forumid ORDER BY lastpost DESC LIMIT 1")) {
      $lastpost=$lastposts[lastpost];
    } else {
      $lastpost=0;
    }

    $DB_site->query("UPDATE forum SET replycount=$numberposts,threadcount=$numberthreads,lastpost=$lastpost WHERE forumid=$forumid");

  }
  if ($checkmore=$DB_site->query_first("SELECT forumid FROM forum WHERE forumid>=$finishat")) {
    echo "<script language=\"javascript\">window.location=\"misc.php?action=updateforum&startat=$finishat&perpage=$perpage\";</script>";
    echo "<p><a href=\"misc.php?action=updateforum&startat=$finishat&perpage=$perpage\">Click here to continue updating forums</a></p>";
  } else {
    echo "<p>All done!</p>";
  }
}

// ###################### Start update threads #######################
if ($action=="updatethread") {

  if (isset($perpage)==0 or $perpage=="") {
    $perpage=2000;
  }
  if (isset($startat)==0 or $startat=="") {
    $startat=0;
  }
  $finishat=$startat+$perpage;
  echo "<p>Thread ids:</p>";

  $threads=$DB_site->query("SELECT MIN(post.postid) AS minpost,MAX(post.postid) AS maxpost,thread.threadid,MAX(post.dateline) AS dateline,(COUNT(post.postid)-1) AS posts FROM post,thread WHERE thread.threadid=post.threadid AND thread.threadid>=$startat AND thread.threadid<$finishat GROUP BY thread.threadid ORDER BY threadid DESC");
  while ($thread=$DB_site->fetch_array($threads)) {

    $threadid=$thread[threadid];

    echo "$threadid<br>\n";
    flush;

    $numberposts=$thread[posts];
    $lastpost=$thread[dateline];
    $firstusername=$DB_site->query_first("SELECT username FROM post WHERE postid=$thread[minpost]");
    $firstusername=$firstusername[username];

    $DB_site->query("UPDATE thread SET lastpost=$lastpost,replycount=$numberposts,postusername='".addslashes($firstusername)."' WHERE threadid=$threadid");
  }
  if ($checkmore=$DB_site->query_first("SELECT threadid FROM thread WHERE threadid>=$finishat")) {
    echo "<script language=\"javascript\">window.location=\"misc.php?action=updatethread&startat=$finishat&perpage=$perpage\";</script>";
    echo "<p><a href=\"misc.php?action=updatethread&startat=$finishat&perpage=$perpage\">Click here to continue updating threads</a></p>";
  } else {
    echo "<p>All done!</p>";
  }

}

?>
</body>
</html>